<?php
// =========================================================================
//                             تنظیمات اصلی (برای هر دو فایل)
// =========================================================================

// --- اطلاعات دیتابیس MySQL شما (حتماً این‌ها را ویرایش کنید) ---
const DB_HOST        = 'localhost'; // معمولاً localhost است
const DB_NAME        = 'steamatl_irancell'; // نام دیتابیسی که در CPanel ساختید
const DB_USER        = 'steamatl_reza';   // نام کاربری دیتابیسی که در CPanel ساختید
const DB_PASS        = 'yg0A}$T-e0g&nN7z'; // رمز عبور دیتابیسی که در CPanel ساختید

// --- اطلاعات ربات تلگرام شما (حتماً این‌ها را ویرایش کنید) ---
const TELEGRAM_BOT_TOKEN = '000'; // توکن ربات تلگرام شما
const TELEGRAM_CHAT_ID   = '000';   // Chat ID که پیام‌ها به آن ارسال شوند

// --- اطلاعات ثابت اپ مای ایرانسل (معمولاً نیازی به تغییر نیست) ---
const CLIENT_ID        = "4725a997e94b372b1c26e425086f4a17";
const CLIENT_SECRET    = "7e9379a4d444a3c21cf28da6a032154dc4b644eba523e7684f71818dec3beeb7";
const CLIENT_VERSION   = "9.59.0"; // نسخه کلاینت ثابت

// --- مسیر فایل‌های ذخیره‌سازی ---
const COOKIE_DIR       = __DIR__ . "/cookies/";             // دایرکتوری برای ذخیره کوکی‌های هر اکانت

// --- آدرس‌های API ---
const TOKEN_URL        = "https://my.irancell.ir/api/authorization/v1/token";
const GIFTS_LIST_URL   = "https://my.irancell.ir/api/gift/v1/gifts";
const ACTIVATE_GIFT_URL = "https://my.irancell.ir/api/gift/v1/gift/activate";

// =========================================================================
//                             متغیرهای عمومی برای لاگ‌دهی تلگرام و گزارش
// =========================================================================
$globalLogBuffer = []; // برای پیام‌های کلی اسکریپت
$accountLogBuffer = []; // برای پیام‌های مربوط به هر اکانت
$lastTelegramMessageTime = 0; // برای جلوگیری از flood کردن تلگرام

// آمار کلی برای گزارش نهایی
$globalSummary = [
    'totalAccounts'       => 0,
    'successfulActivations' => 0,
    'noGiftFound'         => 0,
    'loginFailed'         => 0,
    'refreshTokenFailed'  => 0,
    'activationFailed'    => 0,
    'otherErrors'         => 0,
    'accountDetails'      => [], // برای جزئیات هر اکانت
];


// =========================================================================
//                             توابع کمکی و دیتابیس
// =========================================================================

/**
 * لاگ کردن پیام‌ها به کنسول و بافر تلگرام
 * @param string $message پیام
 * @param string $type نوع پیام (INFO, WARNING, ERROR, FATAL)
 * @param bool $isGlobal آیا پیام عمومی است یا مربوط به یک اکانت خاص
 */
function logMessage($message, $type = 'INFO', $isGlobal = false) {
    $formattedMessage = "[" . date("Y-m-d H:i:s") . "] [$type] $message";
    echo $formattedMessage . "\n"; // همیشه به کنسول چاپ شود

    if ($isGlobal) {
        $GLOBALS['globalLogBuffer'][] = $formattedMessage;
    } else {
        $GLOBALS['accountLogBuffer'][] = $formattedMessage;
    }

    // اگر خطای FATAL بود، بلافاصله به تلگرام ارسال و اسکریپت متوقف شود
    if ($type === 'FATAL') {
        flushLogsToTelegram("Global Fatal Error", true); // ارسال کل لاگ‌ها به تلگرام
        exit(1);
    }
}

/**
 * ارسال پیام به تلگرام (با تقسیم پیام‌های طولانی)
 * @param string $message پیام برای ارسال
 */
function sendTelegramMessage($message) {
    if (TELEGRAM_BOT_TOKEN === 'YOUR_TELEGRAM_BOT_TOKEN' || TELEGRAM_CHAT_ID === 'YOUR_TELEGRAM_CHAT_ID') {
        error_log("Telegram bot token or chat ID is not configured. Skipping Telegram message.");
        return;
    }

    // جلوگیری از ارسال پیام‌های مکرر در بازه زمانی کوتاه (مثلاً هر 2 ثانیه یکبار)
    $minInterval = 2; // seconds
    if (time() - $GLOBALS['lastTelegramMessageTime'] < $minInterval) {
        sleep($minInterval - (time() - $GLOBALS['lastTelegramMessageTime']));
    }

    $chunks = str_split($message, 4000); // Telegram limit is 4096 characters

    foreach ($chunks as $chunk) {
        $url = "https://api-tel.alizam85294.workers.dev/bot" . TELEGRAM_BOT_TOKEN . "/sendMessage";
        $data = [
            'chat_id' => TELEGRAM_CHAT_ID,
            'text'    => $chunk,
            'parse_mode' => 'HTML', // برای فرمت‌بندی بهتر
        ];

        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST           => true,
            CURLOPT_POSTFIELDS     => http_build_query($data),
            CURLOPT_SSL_VERIFYPEER => true, // برای ارتباط با تلگرام این True باشد
            CURLOPT_SSL_VERIFYHOST => 2,    // برای ارتباط با تلگرام این 2 باشد
            CURLOPT_TIMEOUT        => 10,
        ]);
        curl_exec($ch);
        if (curl_errno($ch)) {
            error_log("Telegram API Error: " . curl_error($ch));
        }
        curl_close($ch);
        $GLOBALS['lastTelegramMessageTime'] = time(); // به‌روزرسانی زمان آخرین ارسال
        sleep(1); // یک تاخیر کوتاه بین تکه‌های یک پیام طولانی
    }
}

/**
 * ارسال لاگ‌های بافر شده به تلگرام
 * @param string $title عنوان پیام (مثلاً شماره تلفن اکانت)
 * @param bool $sendGlobalLogs آیا لاگ‌های عمومی هم ارسال شوند (فقط برای گزارش کلی)
 */
function flushLogsToTelegram($title, $sendGlobalLogs = false) {
    $messagesToSend = [];

    if ($sendGlobalLogs && !empty($GLOBALS['globalLogBuffer'])) {
        $messagesToSend[] = "<b>گزارش کلی اسکریپت:</b>\n" . implode("\n", $GLOBALS['globalLogBuffer']);
        $GLOBALS['globalLogBuffer'] = []; // پاک کردن بافر عمومی پس از ارسال
    }

    if (!empty($GLOBALS['accountLogBuffer'])) {
        $messagesToSend[] = "<b>گزارش اکانت " . htmlspecialchars($title) . ":</b>\n" . implode("\n", $GLOBALS['accountLogBuffer']);
        $GLOBALS['accountLogBuffer'] = []; // پاک کردن بافر اکانت پس از ارسال
    }

    foreach ($messagesToSend as $msg) {
        sendTelegramMessage($msg);
    }
}

/**
 * تولید UUID v4
 * @return string UUID v4
 */
function uuidv4() {
    $data = random_bytes(16);
    $data[6] = chr((ord($data[6]) & 0x0f) | 0x40); // Set version to 0100
    $data[8] = chr((ord($data[8]) & 0x3f) | 0x80); // Set bits 6-7 to 10
    return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
}

/**
 * دیکد کردن Base64Url (برای JWT)
 * @param string $data رشته Base64Url
 * @return string دیکد شده
 */
function base64url_decode($data) {
    $remainder = strlen($data) % 4;
    if ($remainder) {
        $padlen = 4 - $remainder;
        $data .= str_repeat('=', $padlen);
    }
    $data = strtr($data, '-_', '+/');
    return base64_decode($data);
}

/**
 * استخراج payload و تاریخ انقضا از JWT
 * @param string $jwt توکن JWT
 * @return array|null شامل 'payload' و 'exp' یا null در صورت خطا
 */
function decodeJwt($jwt) {
    $parts = explode('.', $jwt);
    if (count($parts) !== 3) {
        logMessage("توکن JWT نامعتبر است: " . substr($jwt, 0, 50) . "...", 'WARNING');
        return null;
    }
    $payload = json_decode(base64url_decode($parts[1]), true);
    if ($payload && isset($payload['exp'])) {
        return ['payload' => $payload, 'exp' => $payload['exp']];
    }
    logMessage("Payload از JWT استخراج نشد یا 'exp' وجود ندارد.", 'WARNING');
    return null;
}

/**
 * اتصال به دیتابیس MySQL و ایجاد جدول در صورت عدم وجود
 * @return PDO|null شیء PDO در صورت موفقیت، null در صورت خطا
 */
function initDatabase() {
    try {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
        $pdo = new PDO($dsn, DB_USER, DB_PASS);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        // کوئری CREATE TABLE با مشخصات character set و collation برای UTF-8
        $pdo->exec("CREATE TABLE IF NOT EXISTS accounts (
            id INT AUTO_INCREMENT PRIMARY KEY,
            phoneNumber VARCHAR(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL UNIQUE,
            password VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
            accessToken TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
            refreshToken TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
            installationId VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
            lastRunStatus VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
            lastRunMessage TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
            lastUpdated DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        ) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"); // تنظیم collation برای کل جدول
        return $pdo;
    } catch (PDOException $e) {
        logMessage("Database Error: " . $e->getMessage(), 'FATAL', true);
        return null;
    }
}

/**
 * دریافت لیست همه اکانت‌ها از دیتابیس
 * @param PDO $pdo
 * @return array
 */
function getAccounts(PDO $pdo) {
    try {
        $stmt = $pdo->query("SELECT * FROM accounts ORDER BY id ASC");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        logMessage("Get Accounts Error: " . $e->getMessage(), 'ERROR', true);
        return [];
    }
}

/**
 * به‌روزرسانی اطلاعات یک اکانت در دیتابیس
 * @param PDO $pdo
 * @param int $id
 * @param array $data آرایه‌ای از ستون‌ها برای به‌روزرسانی (مثلاً ['accessToken' => '...', 'refreshToken' => '...'])
 * @return bool
 */
function updateAccount(PDO $pdo, $id, array $data) {
    if (empty($data)) return false;

    $setParts = [];
    $values = [];
    foreach ($data as $key => $value) {
        $setParts[] = "$key = ?";
        $values[] = $value;
    }
    $values[] = $id;

    $sql = "UPDATE accounts SET " . implode(', ', $setParts) . ", lastUpdated = CURRENT_TIMESTAMP WHERE id = ?";
    try {
        $stmt = $pdo->prepare($sql);
        return $stmt->execute($values);
    } catch (PDOException $e) {
        logMessage("Update Account Error for ID $id: " . $e->getMessage(), 'ERROR');
        return false;
    }
}

// =========================================================================
//                             توابع API Call
// =========================================================================

/**
 * ارسال درخواست cURL
 */
function makeRequest($url, $headers, $postData = null, $cookieFile) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER     => $headers,
        CURLOPT_COOKIEJAR      => $cookieFile,
        CURLOPT_COOKIEFILE     => $cookieFile,
        CURLOPT_SSL_VERIFYPEER => false, // برای Irancell API این را false قرار می‌دهیم
        CURLOPT_SSL_VERIFYHOST => false, // برای Irancell API این را false قرار می‌دهیم
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_MAXREDIRS      => 5,
        CURLOPT_TIMEOUT        => 30,
    ]);

    if ($postData) {
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData, JSON_UNESCAPED_UNICODE));
    }

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if (curl_errno($ch)) {
        logMessage("خطای cURL در $url: " . curl_error($ch), 'ERROR');
        curl_close($ch);
        return null;
    }

    curl_close($ch);

    if ($httpCode >= 400) {
        logMessage("خطای HTTP $httpCode در $url. پاسخ: " . $response, 'ERROR');
        return null;
    }

    $jsonResponse = json_decode($response, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        logMessage("خطا در دیکد JSON از $url: " . json_last_error_msg() . ". پاسخ خام: " . substr($response, 0, 200) . "...", 'ERROR');
        return null;
    }

    return $jsonResponse;
}

/**
 * انجام عملیات لاگین کامل برای دریافت access_token و refresh_token
 */
function performLogin($phoneNumber, $password, $installationId, $cookieFile) {
    logMessage("شروع عملیات لاگین کامل برای " . $phoneNumber . "...");

    $payload = [
        "grant_type"       => "password",
        "phone_number"     => $phoneNumber,
        "password"         => $password,
        "device_name"      => "Web PHP Script",
        "client_id"        => CLIENT_ID,
        "client_secret"    => CLIENT_SECRET,
        "client_version"   => CLIENT_VERSION,
        "installation_id"  => $installationId
    ];

    $headers = [
        "Content-Type: application/json",
        "Accept: application/json",
        "Accept-Language: fa",
        "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36",
        "Connection: keep-alive",
        "Origin: https://my.irancell.ir",
        "Referer: https://my.irancell.ir/",
        "Sec-Fetch-Dest: empty",
        "Sec-Fetch-Mode: cors",
        "Sec-Fetch-Site: same-origin",
        "sec-ch-ua: \"Chromium\";v=\"140\", \"Not=A?Brand\";v=\"24\", \"Google Chrome\";v=\"140\"",
        "sec-ch-ua-mobile: ?0",
        "sec-ch-ua-platform: \"Windows\""
    ];

    $response = makeRequest(TOKEN_URL, $headers, $payload, $cookieFile);

    if ($response && isset($response['access_token']) && isset($response['refresh_token'])) {
        logMessage("لاگین موفقیت‌آمیز بود. توکن‌های جدید دریافت شد.");
        return [
            'access_token'    => $response['access_token'],
            'refresh_token'   => $response['refresh_token'],
            'installation_id' => $installationId
        ];
    } else {
        logMessage("لاگین ناموفق برای " . $phoneNumber . ". پاسخ API: " . json_encode($response, JSON_UNESCAPED_UNICODE), 'ERROR');
        return null;
    }
}

/**
 * رفرش کردن توکن‌ها با استفاده از refresh_token و access_token قدیمی
 */
function performRefreshToken($currentAccessToken, $refreshToken, $installationId, $cookieFile) {
    logMessage("تلاش برای رفرش توکن با استفاده از refresh_token موجود...");

    $payload = [
        "grant_type"       => "refresh_token",
        "refresh_token"    => $refreshToken,
        "device_name"      => "Web PHP Script",
        "client_version"   => CLIENT_VERSION,
        "client_id"        => CLIENT_ID,
        "client_secret"    => CLIENT_SECRET,
        "installation_id"  => $installationId
    ];

    $headers = [
        "Content-Type: application/json",
        "Accept: application/json",
        "Accept-Language: fa",
        "Authorization: $currentAccessToken", // بدون پیشوند Bearer
        "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36",
        "Connection: keep-alive",
        "Origin: https://my.irancell.ir",
        "Referer: https://my.irancell.ir/",
        "Sec-Fetch-Dest: empty",
        "Sec-Fetch-Mode: cors",
        "Sec-Fetch-Site: same-origin",
        "sec-ch-ua: \"Chromium\";v=\"140\", \"Not=A?Brand\";v=\"24\", \"Google Chrome\";v=\"140\"",
        "sec-ch-ua-mobile: ?0",
        "sec-ch-ua-platform: \"Windows\""
    ];

    $response = makeRequest(TOKEN_URL, $headers, $payload, $cookieFile);

    if ($response && isset($response['access_token']) && isset($response['refresh_token'])) {
        logMessage("رفرش توکن موفقیت‌آمیز بود. توکن‌های جدید دریافت شد.");
        return [
            'access_token'    => $response['access_token'],
            'refresh_token'   => $response['refresh_token'],
            'installation_id' => $installationId
        ];
    } else {
        logMessage("رفرش توکن ناموفق. پاسخ API: " . json_encode($response, JSON_UNESCAPED_UNICODE), 'WARNING');
        return null;
    }
}

/**
 * گرفتن لیست هدایا
 */
function getGifts($accessToken, $cookieFile) {
    logMessage("در حال گرفتن لیست هدایا با access_token معتبر...");

    $headers = [
        "Accept: application/json, text/plain, */*",
        "Accept-Language: fa",
        "Authorization: $accessToken", // بدون پیشوند Bearer
        "Connection: keep-alive",
        "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36",
        "sec-ch-ua: \"Not;A=Brand\";v=\"99\", \"Google Chrome\";v=\"139\", \"Chromium\";v=\"139\"",
        "sec-ch-ua-mobile: ?0",
        "sec-ch-ua-platform: \"Windows\"",
        "x-app-version: 9.57.0",
        "Referer: https://my.irancell.ir/gamification",
        "Sec-Fetch-Dest: empty",
        "Sec-Fetch-Mode: cors",
        "Sec-Fetch-Site: same-origin"
    ];

    $response = makeRequest(GIFTS_LIST_URL, $headers, null, $cookieFile);

    if ($response && is_array($response)) {
        logMessage("لیست هدایا دریافت شد. تعداد: " . count($response));
        return $response;
    } else {
        logMessage("خطا در دریافت لیست هدایا.", 'ERROR');
        return null;
    }
}

/**
 * فعال‌سازی هدیه
 */
function activateGift($giftId, $accessToken, $cookieFile) {
    logMessage("در حال فعال‌سازی هدیه با ID: $giftId با access_token معتبر...");

    $payload = ["id" => $giftId];

    $headers = [
        "Content-Type: application/json",
        "Accept: application/json, text/plain, */*",
        "Accept-Language: fa",
        "Authorization: $accessToken", // بدون پیشوند Bearer
        "Connection: keep-alive",
        "Origin: https://my.irancell.ir",
        "Referer: https://my.irancell.ir/gamification/giftDetails",
        "Sec-Fetch-Dest: empty",
        "Sec-Fetch-Mode: cors",
        "Sec-Fetch-Site: same-origin",
        "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36",
        "sec-ch-ua: \"Not;A=Brand\";v=\"99\", \"Google Chrome\";v=\"139\", \"Chromium\";v=\"139\"",
        "sec-ch-ua-mobile: ?0",
        "sec-ch-ua-platform: \"Windows\"",
        "x-app-version: 9.57.0"
    ];

    $response = makeRequest(ACTIVATE_GIFT_URL, $headers, $payload, $cookieFile);

    if ($response) {
        logMessage("نتیجه فعال‌سازی هدیه: " . json_encode($response, JSON_UNESCAPED_UNICODE));
        return $response;
    } else {
        logMessage("فعال‌سازی هدیه ناموفق بود.", 'ERROR');
        return null;
    }
}

// =========================================================================
//                             اجرای اصلی اسکریپت
// =========================================================================

logMessage("--- اسکریپت فعال‌سازی هدیه ایرانسل شروع شد ---", 'INFO', true);

// مطمئن شوید دایرکتوری کوکی‌ها وجود دارد
if (!is_dir(COOKIE_DIR)) {
    if (!mkdir(COOKIE_DIR, 0755, true)) {
        logMessage("خطا در ساخت دایرکتوری کوکی‌ها: " . COOKIE_DIR, 'FATAL', true);
    }
}

$pdo = initDatabase();
if (!$pdo) {
    logMessage("خطا در راه‌اندازی دیتابیس. اسکریپت متوقف می‌شود.", 'FATAL', true);
    exit(1);
}

$accounts = getAccounts($pdo);
$GLOBALS['globalSummary']['totalAccounts'] = count($accounts);

if (empty($accounts)) {
    logMessage("هیچ اکانتی در دیتابیس یافت نشد. لطفاً از طریق رابط وب اکانت اضافه کنید.", 'WARNING', true);
    flushLogsToTelegram("Script Summary", true);
    exit(0);
}

// چرخه اصلی برای پردازش هر اکانت
foreach ($accounts as $index => $account) {
    $accountLogBuffer = []; // پاک کردن بافر لاگ برای هر اکانت
    logMessage("--- پردازش اکانت: " . $account['phoneNumber'] . " شروع شد ---");

    $phoneNumber        = $account['phoneNumber'];
    $password           = $account['password'];
    $currentAccessToken = $account['accessToken'];
    $currentRefreshToken = $account['refreshToken'];
    $installationId     = $account['installationId'];
    $accountId          = $account['id'];
    $cookieFile         = COOKIE_DIR . "irancell_cookies_" . $phoneNumber . ".txt";
    $authNeeded         = false;
    $accountStatus      = "Unknown";
    $accountMessage     = "";

    // اگر installationId وجود ندارد، یک مورد جدید تولید کنید
    if (!$installationId) {
        $installationId = uuidv4();
        logMessage("installation_id جدید برای " . $phoneNumber . " تولید شد: " . $installationId);
        $authNeeded = true; // نیاز به لاگین کامل برای ثبت installationId
    }

    // بررسی اعتبار access_token
    if ($currentAccessToken) {
        $decodedToken = decodeJwt($currentAccessToken);
        if ($decodedToken && $decodedToken['exp'] > (time() + 300)) { // 300 ثانیه = 5 دقیقه بافر
            logMessage("access_token برای " . $phoneNumber . " معتبر است و نیازی به رفرش یا لاگین نیست.");
        } else {
            logMessage("access_token برای " . $phoneNumber . " منقضی شده یا در آستانه انقضاست. نیاز به احراز هویت مجدد.");
            $authNeeded = true;
        }
    } else {
        logMessage("access_token برای " . $phoneNumber . " یافت نشد. نیاز به لاگین کامل.");
        $authNeeded = true;
    }

    // اگر نیاز به احراز هویت (لاگین یا رفرش) بود
    $tokensUpdated = false;
    if ($authNeeded) {
        if ($currentRefreshToken) {
            logMessage("تلاش برای رفرش توکن برای " . $phoneNumber . " با استفاده از refresh_token موجود...");
            $newTokens = performRefreshToken($currentAccessToken, $currentRefreshToken, $installationId, $cookieFile);
            if ($newTokens) {
                $currentAccessToken  = $newTokens['access_token'];
                $currentRefreshToken = $newTokens['refresh_token'];
                $installationId      = $newTokens['installation_id']; // اگر تغییر کرد (نباید)، به‌روز شود
                logMessage("توکن‌ها برای " . $phoneNumber . " با موفقیت رفرش شدند.");
                $accountStatus = "Token Refreshed";
                $tokensUpdated = true;
            } else {
                logMessage("رفرش توکن برای " . $phoneNumber . " ناموفق بود یا refresh_token منقضی شده. تلاش برای لاگین کامل...", 'WARNING');
                $GLOBALS['globalSummary']['refreshTokenFailed']++;
                $newTokens = performLogin($phoneNumber, $password, $installationId, $cookieFile);
                if ($newTokens) {
                    $currentAccessToken  = $newTokens['access_token'];
                    $currentRefreshToken = $newTokens['refresh_token'];
                    $installationId      = $newTokens['installation_id'];
                    logMessage("لاگین کامل برای " . $phoneNumber . " موفقیت‌آمیز بود.");
                    $accountStatus = "Logged In";
                    $tokensUpdated = true;
                } else {
                    logMessage("لاگین کامل نیز برای " . $phoneNumber . " ناموفق بود. ادامه عملیات برای این اکانت ممکن نیست.", 'ERROR');
                    $accountStatus = "Login Failed";
                    $accountMessage = "لاگین کامل (و رفرش توکن) ناموفق بود.";
                    $GLOBALS['globalSummary']['loginFailed']++;
                    flushLogsToTelegram($phoneNumber);
                    updateAccount($pdo, $accountId, ['accessToken' => null, 'refreshToken' => null, 'installationId' => $installationId, 'lastRunStatus' => $accountStatus, 'lastRunMessage' => $accountMessage]);
                    continue; // به اکانت بعدی بروید
                }
            }
        } else {
            logMessage("refresh_token برای " . $phoneNumber . " یافت نشد. تلاش برای لاگین کامل...");
            $newTokens = performLogin($phoneNumber, $password, $installationId, $cookieFile);
            if ($newTokens) {
                $currentAccessToken  = $newTokens['access_token'];
                $currentRefreshToken = $newTokens['refresh_token'];
                $installationId      = $newTokens['installation_id'];
                logMessage("لاگین کامل برای " . $phoneNumber . " موفقیت‌آمیز بود.");
                $accountStatus = "Logged In";
                $tokensUpdated = true;
            } else {
                logMessage("لاگین کامل نیز برای " . $phoneNumber . " ناموفق بود. ادامه عملیات برای این اکانت ممکن نیست.", 'ERROR');
                $accountStatus = "Login Failed";
                $accountMessage = "لاگین کامل ناموفق بود.";
                $GLOBALS['globalSummary']['loginFailed']++;
                flushLogsToTelegram($phoneNumber);
                updateAccount($pdo, $accountId, ['accessToken' => null, 'refreshToken' => null, 'installationId' => $installationId, 'lastRunStatus' => $accountStatus, 'lastRunMessage' => $accountMessage]);
                continue; // به اکانت بعدی بروید
            }
        }
    }

    // اگر توکن‌ها به روز شدند یا installationId جدید بود، آن را در دیتابیس ذخیره کنید.
    // این ensures می‌کند که installationId همیشه ذخیره می‌شود.
    if ($tokensUpdated || ($account['installationId'] !== $installationId && $installationId !== null)) {
        updateAccount($pdo, $accountId, [
            'accessToken' => $currentAccessToken,
            'refreshToken' => $currentRefreshToken,
            'installationId' => $installationId,
        ]);
    }


    // حالا که access_token معتبر داریم، می‌توانیم هدیه را فعال کنیم
    if ($currentAccessToken) {
        $gifts = getGifts($currentAccessToken, $cookieFile);
        if ($gifts && !empty($gifts)) {
            $firstGiftId = $gifts[0]['id'];
            logMessage("اولین هدیه برای " . $phoneNumber . " پیدا شد: ID = " . $firstGiftId);
            $activateResult = activateGift($firstGiftId, $currentAccessToken, $cookieFile);
            if ($activateResult && isset($activateResult['message']) && $activateResult['message'] === 'done') { // بررسی دقیق‌تر پاسخ "done"
                $accountStatus = "Activation Success";
                $accountMessage = "هدیه با موفقیت فعال شد. ";
                $GLOBALS['globalSummary']['successfulActivations']++;
            } else {
                $accountStatus = "Activation Failed";
                $accountMessage = "فعال‌سازی هدیه ناموفق بود. " . json_encode($activateResult, JSON_UNESCAPED_UNICODE);
                $GLOBALS['globalSummary']['activationFailed']++;
            }
        } else {
            $accountStatus = "No Gift Found";
            $accountMessage = "هیچ هدیه‌ای برای فعال‌سازی یافت نشد.";
            $GLOBALS['globalSummary']['noGiftFound']++;
        }
    } else {
        $accountStatus = "Error (No Access Token)";
        $accountMessage = "Access token در دسترس نیست. ادامه عملیات ممکن نیست.";
        $GLOBALS['globalSummary']['otherErrors']++;
    }

    // به‌روزرسانی نهایی وضعیت اجرا و پیام در دیتابیس
    updateAccount($pdo, $accountId, [
        'lastRunStatus' => $accountStatus,
        'lastRunMessage' => $accountMessage
    ]);

    logMessage("--- پردازش اکانت: " . $phoneNumber . " به پایان رسید ---");
    flushLogsToTelegram($phoneNumber); // ارسال لاگ‌های این اکانت به تلگرام

    // ذخیره جزئیات برای گزارش کلی
    $GLOBALS['globalSummary']['accountDetails'][] = [
        'phoneNumber' => $phoneNumber,
        'status' => $accountStatus,
        'message' => $accountMessage,
    ];
}

logMessage("--- اسکریپت فعال‌سازی هدیه ایرانسل به پایان رسید ---", 'INFO', true);

// =========================================================================
//                             گزارش جامع تلگرام
// =========================================================================

$finalReport = "<b>گزارش جامع ایرانسل - " . date("Y-m-d H:i:s") . "</b>\n\n";
$finalReport .= "<b>وضعیت کلی:</b>\n";
$finalReport .= "➖ تعداد اکانت‌های پردازش شده: " . $GLOBALS['globalSummary']['totalAccounts'] . "\n";
$finalReport .= "✅ فعال‌سازی موفق: " . $GLOBALS['globalSummary']['successfulActivations'] . "\n";
$finalReport .= "🎁 هدیه یافت نشد: " . $GLOBALS['globalSummary']['noGiftFound'] . "\n";
$finalReport .= "❌ لاگین ناموفق: " . $GLOBALS['globalSummary']['loginFailed'] . "\n";
$finalReport .= "⚠️ رفرش توکن ناموفق: " . $GLOBALS['globalSummary']['refreshTokenFailed'] . "\n";
$finalReport .= "🚫 فعال‌سازی ناموفق: " . $GLOBALS['globalSummary']['activationFailed'] . "\n";
$finalReport .= "❓ سایر خطاها: " . $GLOBALS['globalSummary']['otherErrors'] . "\n\n";

if (!empty($GLOBALS['globalSummary']['accountDetails'])) {
    $finalReport .= "<b>جزئیات اکانت‌ها:</b>\n";
    foreach ($GLOBALS['globalSummary']['accountDetails'] as $detail) {
        $statusEmoji = '';
        if (strpos($detail['status'], 'Success') !== false) $statusEmoji = '✅';
        elseif (strpos($detail['status'], 'No Gift') !== false) $statusEmoji = '🎁';
        elseif (strpos($detail['status'], 'Failed') !== false || strpos($detail['status'], 'Error') !== false || strpos($detail['status'], 'Login') !== false) $statusEmoji = '❌';
        else $statusEmoji = 'ℹ️';
        
        $finalReport .= "$statusEmoji <code>" . $detail['phoneNumber'] . "</code>: " . htmlspecialchars($detail['status']) . "\n";
        if (!empty($detail['message'])) {
            $finalReport .= "  <i>" . htmlspecialchars($detail['message']) . "</i>\n";
        }
    }
}

sendTelegramMessage($finalReport);

?>