<?php
// =========================================================================
//                             تنظیمات اصلی (برای هر دو فایل)
// =========================================================================

// --- اطلاعات دیتابیس MySQL شما (حتماً این‌ها را ویرایش کنید) ---
const DB_HOST        = 'localhost'; // معمولاً localhost است
const DB_NAME        = 'steamatl_irancell'; // نام دیتابیسی که در CPanel ساختید
const DB_USER        = 'steamatl_reza';   // نام کاربری دیتابیسی که در CPanel ساختید
const DB_PASS        = 'yg0A}$T-e0g&nN7z'; // رمز عبور دیتابیسی که در CPanel ساختید

// --- اطلاعات ربات تلگرام شما (حتماً این‌ها را ویرایش کنید) ---
const TELEGRAM_BOT_TOKEN = '000'; // توکن ربات تلگرام شما
const TELEGRAM_CHAT_ID   = '000';   // Chat ID که پیام‌ها به آن ارسال شوند

// --- اطلاعات ثابت اپ مای ایرانسل (معمولاً نیازی به تغییر نیست) ---
const CLIENT_ID        = "4725a997e94b372b1c26e425086f4a17";
const CLIENT_SECRET    = "7e9379a4d444a3c21cf28da6a032154dc4b644eba523e7684f71818dec3beeb7";
const CLIENT_VERSION   = "9.59.0"; // نسخه کلاینت ثابت

// --- مسیر فایل‌های ذخیره‌سازی ---
const COOKIE_DIR       = __DIR__ . "/cookies/";             // دایرکتوری برای ذخیره کوکی‌های هر اکانت

// --- آدرس‌های API (برای Worker، نه این فایل) ---
const TOKEN_URL        = "https://my.irancell.ir/api/authorization/v1/token";
const GIFTS_LIST_URL   = "https://my.irancell.ir/api/gift/v1/gifts";
const ACTIVATE_GIFT_URL = "https://my.irancell.ir/api/gift/v1/gift/activate";

// =========================================================================
//                             توابع دیتابیس
// =========================================================================

/**
 * اتصال به دیتابیس MySQL و ایجاد جدول در صورت عدم وجود
 * @return PDO|null شیء PDO در صورت موفقیت، null در صورت خطا
 */
function initDatabase() {
    try {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
        $pdo = new PDO($dsn, DB_USER, DB_PASS);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        // کوئری CREATE TABLE با مشخصات character set و collation برای UTF-8
        $pdo->exec("CREATE TABLE IF NOT EXISTS accounts (
            id INT AUTO_INCREMENT PRIMARY KEY,
            phoneNumber VARCHAR(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL UNIQUE,
            password VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
            accessToken TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
            refreshToken TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
            installationId VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
            lastRunStatus VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
            lastRunMessage TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
            lastUpdated DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        ) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"); // تنظیم collation برای کل جدول
        return $pdo;
    } catch (PDOException $e) {
        error_log("Database Error: " . $e->getMessage());
        return null;
    }
}

/**
 * اضافه کردن یک اکانت جدید به دیتابیس
 * @param PDO $pdo
 * @param string $phoneNumber
 * @param string $password
 * @return bool|string "duplicate" اگر شماره تکراری باشد، true در صورت موفقیت، false در صورت خطا
 */
function addAccount(PDO $pdo, $phoneNumber, $password) {
    try {
        $stmt = $pdo->prepare("INSERT INTO accounts (phoneNumber, password) VALUES (?, ?)");
        return $stmt->execute([$phoneNumber, $password]);
    } catch (PDOException $e) {
        if ($e->getCode() == 23000) { // Unique constraint violation for MySQL
            return "duplicate"; // شماره تکراری
        }
        error_log("Add Account Error: " . $e->getMessage());
        return false;
    }
}

/**
 * دریافت لیست همه اکانت‌ها از دیتابیس
 * @param PDO $pdo
 * @return array
 */
function getAccounts(PDO $pdo) {
    try {
        $stmt = $pdo->query("SELECT * FROM accounts ORDER BY id DESC");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        error_log("Get Accounts Error: " . $e->getMessage());
        return [];
    }
}

// =========================================================================
//                             پردازش درخواست‌های وب
// =========================================================================

$pdo = initDatabase();
if (!$pdo) {
    die("<h1>خطا در اتصال به دیتابیس. لطفا لاگ سرور را بررسی کنید.</h1>");
}

$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['phoneNumber']) && isset($_POST['password'])) {
    $phoneNumber = trim($_POST['phoneNumber']);
    $password = trim($_POST['password']);

    if (empty($phoneNumber) || empty($password)) {
        $message = '<div style="color: red;">شماره موبایل و رمز عبور نمی‌توانند خالی باشند.</div>';
    } elseif (!preg_match('/^989\d{9}$/', $phoneNumber)) {
        $message = '<div style="color: red;">فرمت شماره موبایل نامعتبر است. باید به فرمت 989xxxxxxxxx باشد.</div>';
    } else {
        $result = addAccount($pdo, $phoneNumber, $password);
        if ($result === true) {
            $message = '<div style="color: green;">اکانت با موفقیت اضافه شد.</div>';
        } elseif ($result === "duplicate") {
            $message = '<div style="color: orange;">این شماره موبایل قبلا اضافه شده است.</div>';
        } else {
            $message = '<div style="color: red;">خطا در اضافه کردن اکانت.</div>';
        }
    }
}

$accounts = getAccounts($pdo);
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>مدیریت اکانت‌های ایرانسل</title>
    <style>
        body { font-family: Tahoma, sans-serif; margin: 20px; background-color: #f4f4f4; color: #333; }
        .container { max-width: 900px; margin: 0 auto; background-color: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        h1, h2 { color: #007bff; text-align: center; }
        form { margin-bottom: 30px; padding: 20px; border: 1px solid #ddd; border-radius: 5px; }
        form label { display: block; margin-bottom: 5px; font-weight: bold; }
        form input[type="text"], form input[type="password"] { width: calc(100% - 22px); padding: 10px; margin-bottom: 15px; border: 1px solid #ccc; border-radius: 4px; }
        form button { background-color: #28a745; color: white; padding: 10px 15px; border: none; border-radius: 4px; cursor: pointer; font-size: 16px; }
        form button:hover { background-color: #218838; }
        .message { margin-top: 10px; padding: 10px; border-radius: 4px; text-align: center; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        table, th, td { border: 1px solid #ddd; }
        th, td { padding: 12px; text-align: right; }
        th { background-color: #007bff; color: white; }
        tr:nth-child(even) { background-color: #f2f2f2; }
        tr:hover { background-color: #e9e9e9; }
        .status-success { color: green; font-weight: bold; }
        .status-fail { color: red; font-weight: bold; }
        .status-warn { color: orange; font-weight: bold; }
        .note { background-color: #fff3cd; color: #856404; border: 1px solid #ffeeba; padding: 15px; border-radius: 5px; margin-top: 20px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>مدیریت اکانت‌های ایرانسل</h1>

        <?php if ($message): ?>
            <div class="message"><?php echo $message; ?></div>
        <?php endif; ?>

        <form action="index.php" method="POST">
            <h2>افزودن اکانت جدید</h2>
            <label for="phoneNumber">شماره موبایل (مثال: 989123456789):</label>
            <input type="text" id="phoneNumber" name="phoneNumber" placeholder="989xxxxxxxxx" required pattern="989\d{9}">

            <label for="password">رمز عبور ایرانسل:</label>
            <input type="password" id="password" name="password" required>

            <button type="submit">افزودن اکانت</button>
        </form>

        <h2>لیست اکانت‌ها</h2>
        <?php if (empty($accounts)): ?>
            <p style="text-align: center;">هیچ اکانتی اضافه نشده است.</p>
        <?php else: ?>
            <table>
                <thead>
                    <tr>
                        <th>شماره موبایل</th>
                        <th>آخرین وضعیت</th>
                        <th>پیام آخرین اجرا</th>
                        <th>آخرین به‌روزرسانی</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($accounts as $account): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($account['phoneNumber']); ?></td>
                            <td class="<?php 
                                if (strpos($account['lastRunStatus'] ?? '', 'Success') !== false) echo 'status-success';
                                elseif (strpos($account['lastRunStatus'] ?? '', 'Failed') !== false || strpos($account['lastRunStatus'] ?? '', 'Error') !== false) echo 'status-fail';
                                elseif (strpos($account['lastRunStatus'] ?? '', 'No Gift') !== false || strpos($account['lastRunStatus'] ?? '', 'Warning') !== false) echo 'status-warn';
                            ?>">
                                <?php echo htmlspecialchars($account['lastRunStatus'] ?? 'در انتظار اجرا'); ?>
                            </td>
                            <td><?php echo htmlspecialchars($account['lastRunMessage'] ?? '---'); ?></td>
                            <td><?php echo htmlspecialchars($account['lastUpdated'] ?? '---'); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>

        <div class="note">
            <p><strong>نکات مهم:</strong></p>
            <ul>
                <li>این صفحه برای مدیریت اکانت‌هاست. عملیات فعال‌سازی هدیه به صورت خودکار توسط اسکریپت `irancell_worker.php` که باید در کرون جاب تنظیم شود، انجام می‌گردد.</li>
                <li>توکن‌های `access_token` و `refresh_token` و `installationId` به صورت خودکار توسط اسکریپت worker مدیریت و در دیتابیس ذخیره می‌شوند. نیازی به ورود دستی آن‌ها نیست.</li>
                <li>رمز عبور شما به صورت متن ساده در دیتابیس ذخیره می‌شود. لطفاً از این اسکریپت فقط در سرورهای شخصی و امن استفاده کنید.</li>
                <li>گزارش‌های جامع به ربات تلگرام شما ارسال خواهد شد.</li>
            </ul>
        </div>
    </div>
</body>
</html>